# Chapter 2: File and Directory Management

Cheat sheet of commands used in this chapter:

- List files in current directory: `ls`
- List files in a different directory: `ls /etc`
- List hidden (dot) files: `ls -a`
- List file attributes: `ls -l`
- List file size in human-readable format: `ls -lh`
- List file attributes, sorted by date/time: `ls -lt`
- List file attributes, sorted by date/time in reverse: `ls -ltr`
- Make a new empty file: `touch`
- Make a new directory: `mkdir`
- Make a new directory inside of another new directory: `mkdir -p`
- Copy a file: `cp [source] [destination]`
- Delete a file: `rm [file]`
- Delete a directory: `rm -f [directory]`
- Delete a directory without prompting: `rm -rf [directory]
- Get help on a command: `man [command]`
- Print the current working directory: `pwd`
- Change directory: `cd [/path/to/directory]`
- Change directory, remembering your current directory: `pushd`
- Change to the previous directory: `popd`
- Change to the previous directory (shortcut): `cd -`
- Change to your home directory: `cd ~`
- Change ownership of a file: `chown [user]:[group] [file]`
- Change file permissions: `chmod [nnn] file`, where n is an octal number.
- Create a hard symbolic link: `ln`
- Create a soft symbolic link: `ls -s`
- Create a symbolic link named /home/src and point it to /usr/src: `ln -s /usr/src /home/src`