#!/bin/bash

# Our list of users and emails
user_list="john_doe: john.doe@example.com
jane_smith: jane.smith@example.com"

# Regex pattern to match usernames and emails
pattern="([a-zA-Z0-9_]+): ([a-zA-Z0-9_.]+@[a-zA-Z0-9_.]+)"

# Loop through each line in the user list
while read -r line; do
  if [[ $line =~ $pattern ]]; then
    username="${BASH_REMATCH[1]}"
    email="${BASH_REMATCH[2]}"
    echo "Username: $username, Email: $email"
  fi
done <<< "$user_list"
