#!/usr/bin/env bash
IP_RANGE="10.2.10.{1..20}"
PORTS=(21 22 23 25 53 80 110 143 443 587 3306 3389 5900 8000 8080 9000 49152 49153 49154 49155 49156 49157 49158 49159 49160 49161 49162 49163 49164 49165 49166 49167 49168 49169 49170 49171 49172 49173 49174 49175 49176 49177 49178 49179 49180 49181 49182 49183 49184 49185 49186 49187 49188 49189 49190 49191 49192 49193 49194 49195 49196 49197 49198 49199 49200 49201 49202 49203 49204 49205 49206 49207 49208 49209 49210 49211 49212 49213 49214 49215 49216 49217 49218 49219 49220 49221 49222 49223 49224 49225 49226 49227 49228 49229 49230 49231)
LIVE_HOSTS=()
for IP in $(eval echo $IP_RANGE); do
    if ping -c 1 -W 1 $IP > /dev/null 2>&1; then
        LIVE_HOSTS+=($IP)
    fi
done

scan_ports() {
    local IP=$1
    for PORT in "${PORTS[@]}"; do
        (echo >/dev/tcp/$IP/$PORT) > /dev/null 2>&1 && echo "$IP:$PORT"
    done
}

# Export the function to use in subshells
export -f scan_ports

# Loop through live hosts and scan ports in parallel
for IP in "${LIVE_HOSTS[@]}"; do
    scan_ports $IP &
done
echo “Waiting for port scans to complete…”
wait
