#!/usr/bin/env bash

# Function to perform a task
perform_task() {
    echo "Starting task $1"
    sleep 5  # Simulating work
    echo "Finished task $1"
}

# Create a new screen session
screen -dmS parallel_tasks

# Start multiple tasks in separate screen windows
for i in {1..5}; do
    screen -S parallel_tasks -X screen -t "Task $i" bash -c "perform_task $i; exec bash"
done

# Wait for all tasks to complete
screen -S parallel_tasks -X windowlist -b

# Clean up the screen session
screen -S parallel_tasks -X quit

echo "All tasks completed"