dnsrecon() {
    # Check if the correct number of arguments is provided
    if [[ $# -ne 1 ]]; then
        # Print the usage information if the arguments are incorrect
        echo "You didn't provide a domain as input."
        echo "Usage: $0 [domain]"
        exit 1
    fi

    # Check if chaos API key is set in env.
    if [[ -z "$CHAOS_KEY" ]]; then
        echo "No chaos API key found. Set env CHAOS_KEY."
        exit 1
    fi

    local domain=$1
    local domains=''
    local roots=''
    
    # Use the mdi function to get the list of related domains
    mdi_result=$(mdi <<< "$domain")
    # If no domains are returned from the mdi funtion, pass input domain directly to chaos api.
    if [[ -z "$mdi_result" ]]; then
        # Pass the input domain to chaos api and assign the output to a variable.
        domains=$(chaos -silent -d "$domain")
    else
        # Find all root domains.
        while IFS= read -r line; do
            root=$(rootdomain <<< "$line")
            chaos_domains=$(chaos -silent -d "$root")
            domains=$(echo -e "$domains\n$chaos_domains")
        done <<< "$mdi_result"
        # Unique the domains.
        #domains=$(echo "$domains" | grep . | grep -v \* | sort -u)
    fi
    # Process the function output.
    echo "$domains" | while IFS= read -r line; do
        ip=$(resolve <<< "$line")
        if [[ -z "$ip" ]]; then
            continue
        fi
        orgname=$(org <<< "$ip")
        echo "$line;$ip;$orgname"
    done
}