mdi() {
    # This function takes a domain as input and checks MDI and returns domains using the same tenant.
    while IFS= read -r line; do
        body="<?xml version=\"1.0\" encoding=\"utf-8\"?>
    <soap:Envelope xmlns:exm=\"http://schemas.microsoft.com/exchange/services/2006/messages\" 
        xmlns:ext=\"http://schemas.microsoft.com/exchange/services/2006/types\" 
        xmlns:a=\"http://www.w3.org/2005/08/addressing\" 
        xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" 
        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">
    <soap:Header>
        <a:RequestedServerVersion>Exchange2010</a:RequestedServerVersion>
        <a:MessageID>urn:uuid:6389558d-9e05-465e-ade9-aae14c4bcd10</a:MessageID>
        <a:Action soap:mustUnderstand=\"1\">http://schemas.microsoft.com/exchange/2010/Autodiscover/Autodiscover/GetFederationInformation</a:Action>
        <a:To soap:mustUnderstand=\"1\">https://autodiscover.byfcxu-dom.extest.microsoft.com/autodiscover/autodiscover.svc</a:To>
        <a:ReplyTo>
        <a:Address>http://www.w3.org/2005/08/addressing/anonymous</a:Address>
        </a:ReplyTo>
    </soap:Header>
    <soap:Body>
        <GetFederationInformationRequestMessage xmlns=\"http://schemas.microsoft.com/exchange/2010/Autodiscover\">
        <Request>
            <Domain>${line}</Domain>
        </Request>
        </GetFederationInformationRequestMessage>
    </soap:Body>
    </soap:Envelope>"

    # Perform the HTTP POST request using curl and store the response
    response=$(curl -s -X POST -H "Content-type: text/xml; charset=utf-8" -H "User-agent: AutodiscoverClient" -d "$body" "https://autodiscover-s.outlook.com/autodiscover/autodiscover.svc")

    # Check if the response is empty, indicating a failed request
    if [[ -z "$response" ]]; then
        echo "[-] get_mdi_domains(): Unable to execute request."
        exit 1
    fi

    # Parse the XML response to extract domain names using xmllint
    mdi_domains=$(echo "$response" | xmllint --xpath '//*[local-name()="Domain"]/text()' -)
    echo "$mdi_domains"
    done
}
