md5_hash() {
  md5sum | awk '{print $1}'
}

sha256_hash() {
  sha256sum | awk '{print $1}'
}

aes_encrypt() {
  local password="$1"
  openssl enc -aes-256-cbc -base64 -pbkdf2 -pass pass:"$password"
}

aes_decrypt() {
  local password="$1"
  openssl enc -aes-256-cbc -d -base64 -pbkdf2 -pass pass:"$password"
}

url_safe_base64_encode() {
  base64 | tr '+/' '-_' | tr -d '='
}

url_safe_base64_decode() {
  tr '-_' '+/' | base64 --decode
}

html_encode() {
  local input
  input=$(cat)
  input="${input//\&/\&amp;}"
  input="${input//\</\&lt;}"
  input="${input//\>/\&gt;}"
  input="${input//\"/\&quot;}"
  input="${input//\'/\&apos;}"
  echo "$input"
}

html_decode() {
  local input
  input=$(cat)
  input="${input//\&apos;/\'}"
  input="${input//\&quot;/\"}"
  input="${input//\&gt;/\>}"
  input="${input//\&lt;/\<}"
  input="${input//\&amp;/\&}"
  echo "$input"
}

url_encode() {
  local input="$1"
  local output=""
  local length="${#input}"

  for (( i = 0; i < length; i++ )); do
    local c="${input:$i:1}"
    case "$c" in
      [a-zA-Z0-9.~_-]) output+="$c" ;;
      ' ') output+="+" ;;
      *) output+="$(printf '%%%02X' "'$c")" ;;
    esac
  done
  echo "$output"
}

url_decode() {
  local input="$1"
  local output="${input//+/ }"
  printf -v output '%b' "${output//%/\\x}"
  echo "$output"
}
