#!/usr/bin/env bash

# Get the PATH environment variable
path_dirs=$(echo $PATH | tr ':' '\n')

# Function to check write permissions recursively
check_permissions() {
  local dir=$1
  echo "[i] Checking write permissions for $dir and its subdirectories:"
  
  find "$dir" -type d | while read subdir; do
    if [ -w "$subdir" ]; then
      echo "[!] $subdir is writable!"
    else
      echo "[-] $subdir is not writable"
    fi
  done
}

# Loop through each directory in PATH and check write permissions recursively
for dir in $path_dirs; do
  if [ -d "$dir" ]; then
    check_permissions "$dir"
  fi
done
