#!/usr/bin/env bash

# Function to encode a string using base64
encode_base64() {
    echo "$1" | base64
}
# Function to obfuscate variable names
obfuscate_var_name() {
    echo "var_$(openssl rand -hex 4)"
}

# Function to obfuscate a command using command substitution
obfuscate_command() {
    local cmd="$1"
    echo "$(echo "$cmd" | od -A n -t x1 | tr -d ' \n')"
}
# Main function to generate an obfuscated script
generate_obfuscated_script() {
    local original_script="$1"
    local obfuscated_script=""
    while IFS= read -r line; do
# Obfuscate variable assignments
        if [[ "$line" =~ ^[[:space:]]*([a-zA-Z_][a-zA-Z0-9_]*)[[:space:]]*= ]]; then
            var_name="${BASH_REMATCH[1]}"
            new_var_name=$(obfuscate_var_name)
            line="${line//$var_name/$new_var_name}"
        fi
# Obfuscate commands
        if [[ "$line" =~ ^[[:space:]]*([-a-zA-Z0-9_]+) ]]; then
            cmd="${BASH_REMATCH[1]}"
            obfuscated_cmd=$(obfuscate_command "$cmd")
            line="${line//$cmd/\$(echo -e \"\x$(echo "$obfuscated_cmd" | sed 's/../\\x&/g')\")}"
        fi
obfuscated_script+="$line"$'\n'
    done < "$original_script"

    echo "$obfuscated_script"
}

original_script="original_script.sh"
obfuscated_script=$(generate_obfuscated_script "$original_script")
echo "$obfuscated_script" > obfuscated_script.sh
