#!/usr/bin/env bash

# Array to store obfuscation techniques
obfuscation_techniques=()

# Function to add an obfuscation technique
add_obfuscation_technique() {
    obfuscation_techniques+=("$1")
}

# Example obfuscation techniques
obfuscate_base64() {
    echo "echo '$1' | base64 -d | bash"
}

obfuscate_hex() {
    echo "echo -e '$(echo "$1" | od -A n -t x1 | tr -d ' \n')' | bash"
}

obfuscate_eval() {
    echo "eval '$1'"
}

# Add techniques to the array
add_obfuscation_technique obfuscate_base64
add_obfuscation_technique obfuscate_hex
add_obfuscation_technique obfuscate_eval

# Function to apply a random obfuscation technique
apply_random_obfuscation() {
    local content="$1"
    local technique_index=$((RANDOM % ${#obfuscation_techniques[@]}))
    local chosen_technique="${obfuscation_techniques[$technique_index]}"
    $chosen_technique "$content"
}

# Main function to generate an obfuscated script
generate_obfuscated_script() {
    local original_script="$1"
    local obfuscated_script=""

    while IFS= read -r line; do
        obfuscated_line=$(apply_random_obfuscation "$line")
        obfuscated_script+="$obfuscated_line"$'\n'
    done < "$original_script"

    echo "$obfuscated_script"
}

# Usage
original_script="original_script.sh"
obfuscated_script=$(generate_obfuscated_script "$original_script")
echo "$obfuscated_script" > obfuscated_script.sh
