#!/usr/bin/env bash

# Source the evasion library
source ch14_evasion_library.sh

# Array to store obfuscation techniques
obfuscation_techniques=()

# Function to add an obfuscation technique
add_obfuscation_technique() {
    obfuscation_techniques+=("$1")
}

# Add techniques from the evasion library
add_obfuscation_technique evade_base64
add_obfuscation_technique evade_hex
add_obfuscation_technique evade_command_substitution
add_obfuscation_technique evade_env_var
add_obfuscation_technique evade_arithmetic
add_obfuscation_technique evade_sleep

# Function to apply a random obfuscation technique
apply_random_obfuscation() {
    local content="$1"
    local technique_index=$((RANDOM % ${#obfuscation_techniques[@]}))
    local chosen_technique="${obfuscation_techniques[$technique_index]}"
    $chosen_technique "$content"
}

# Main function to generate an obfuscated script
generate_obfuscated_script() {
    local original_script="$1"
    local obfuscated_script=""

    while IFS= read -r line; do
        obfuscated_line=$(apply_random_obfuscation "$line")
        obfuscated_script+="$obfuscated_line"$'\n'
    done < "$original_script"

    echo "$obfuscated_script"
}

# Usage
original_script="original_script.sh"
obfuscated_script=$(generate_obfuscated_script "$original_script")
echo "$obfuscated_script" > obfuscated_script.sh
