#!/usr/bin/env bash

source ch14_evasion_library.sh

# Function to apply multiple random obfuscation techniques
apply_multiple_obfuscations() {
    local content="$1"
    local num_techniques=$((RANDOM % 3 + 1))  # Apply 1 to 3 techniques
    
    for ((i=0; i<num_techniques; i++)); do
        local technique_index=$((RANDOM % ${#obfuscation_techniques[@]}))
        local chosen_technique="${obfuscation_techniques[$technique_index]}"
        content=$($chosen_technique "$content")
    done
    
    echo "$content"
}

# Main function to generate an obfuscated script
generate_obfuscated_script() {
    local original_script="$1"
    local obfuscated_script=""

    while IFS= read -r line; do
        if [[ -n "$line" && ! "$line" =~ ^[[:space:]]*# ]]; then
            obfuscated_line=$(apply_multiple_obfuscations "$line")
            obfuscated_script+="$obfuscated_line"$'\n'
        else
            obfuscated_script+="$line"$'\n'
        fi
    done < "$original_script"

    echo "$obfuscated_script"
}

# Usage
original_script="original_script.sh"
obfuscated_script=$(generate_obfuscated_script "$original_script")
echo "$obfuscated_script" > obfuscated_script.sh
