#!/usr/bin/env bash

SERVER_IP="10.2.10.99"  # Replace with your actual server IP
DOMAIN="example.com"

function retrieve_data() {
    local key="$1"
    echo "Sending query for: $key.get.$DOMAIN to $SERVER_IP"
    local result=$(dig @$SERVER_IP +short TXT "$key.get.$DOMAIN")

    if [ -n "$result" ]; then
        # Remove quotes and decode
        local decoded=$(echo $result | tr -d '"' | base64 -d 2>/dev/null)
        if [ $? -eq 0 ]; then
            echo "Retrieved data for '$key': $decoded"
        else
            echo "Error decoding data for '$key'. Raw data: $result"
        fi
    else
        echo "No data found for '$key'"
    fi
    echo "-------------------"
}

# Example usage
retrieve_data "weather"
retrieve_data "news"
retrieve_data "quote"
retrieve_data "nonexistent"