#!/bin/bash

URL="https://raw.githubusercontent.com/rapid7/metasploit-framework/refs/heads/master/db/modules_metadata_base.json"

# Print the header row
echo -e "Name\tFullname\tDescription\tReferences\tRport"

# Fetch and process the JSON data
curl -s "$URL" | jq -r '
  to_entries[] | 
  [
    .value.name,
    .value.fullname,
    .value.description,
    (.value.references | join(", ")),
    .value.rport
  ] | @tsv
' | awk -F'\t' 'BEGIN {OFS="\t"}
{
    # Clean up all fields
    for (i=1; i<=NF; i++) {
        # Remove actual newlines
        gsub(/\n/, " ", $i)
        # Remove "\n" literals
        gsub(/\\n/, " ", $i)
        # Remove tabs
        gsub(/\t/, " ", $i)
        # Remove excessive spaces
        gsub(/[ \t]+/, " ", $i)
        # Trim leading and trailing spaces
        sub(/^[ \t]+/, "", $i)
        sub(/[ \t]+$/, "", $i)
    }
    print
}' > metasploitdb.csv
