# Digital Forensics with Kali Linux

<a href="https://www.packtpub.com/product/digital-forensics-with-kali-linux-third-edition/9781837635153"><img src="https://m.media-amazon.com/images/I/412KbPLN2uL._SX403_BO1,204,203,200_.jpg" alt="Book Name" height="256px" align="right"></a>

This is the code repository for [Digital Forensics with Kali Linux](https://www.packtpub.com/product/digital-forensics-with-kali-linux-third-edition/9781837635153), published by Packt.

**Enhance your investigation skills by performing network and memory forensics with Kali Linux 2022.x**

## What is this book about?
Kali Linux is a Linux-based distribution that's widely used for penetration testing and digital forensics. This third edition is updated with real-world examples and detailed labs to help you take your investigation skills to the next level using powerful tools.This new edition will help you explore modern techniques for analysis, extraction, and reporting using advanced tools such as FTK Imager, Hex Editor, and Axiom. You’ll cover the basics and advanced areas of digital forensics within the world of modern forensics while delving into the domain of operating systems.

This book covers the following exciting features: 
* Install Kali Linux on Raspberry Pi 4 and various other platforms
* Run Windows applications in Kali Linux using Windows Emulator as Wine
* Recognize the importance of RAM, file systems, data, and cache in DFIR
* Perform file recovery, data carving, and extraction using Magic Rescue
* Get to grips with the latest Volatility 3 framework and analyze the memory dump
* Perform full DFIR automated analysis with Autopsy 4

If you feel this book is for you, get your [copy](https://www.amazon.com/Digital-Forensics-Kali-Linux-investigation/dp/1837635153) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, Chapter05.

The code will look like the following:
```
sudo dpkg --add-architecture i386
sudo mv winehq.key /usr/share/keyrings/winehq-archive.key
sudo mv winehq-bullseye.sources /etc/apt/sources.list.d/
sudo apt install --install-recommends winehq-stable
```

**Following is what you need for this book:**
This book is for students, forensic analysts, digital forensics investigators and incident responders, security analysts and administrators, penetration testers, or anyone interested in enhancing their forensics abilities using the latest version of Kali Linux along with powerful automated analysis tools. Basic knowledge of operating systems, computer components, and installation processes will help you gain a better understanding of the concepts covered.

With the following software and hardware list you can run all code files present in the book (Chapter 1-16).

### Software and Hardware List

| Chapter  | Software required                                                       | OS required                       |
| -------- | ------------------------------------------------------------------------| ----------------------------------|
| 1-16     | Kali 2022.x and later, Oracle VM Virtualbox, VMware Workstation Pro     | Windows, Mac OS X, and Linux (Any)|
| 2,15     | Deft Linux                                                              | Windows, Mac OS X, and Linux (Any)|
| 2        | Caine Linux, CSI Linux                                                  | Windows, Mac OS X, and Linux (Any)|

We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it]( https://packt.link/vLuYi).

### Related products <Other books you may enjoy>
* The Ultimate Kali Linux Book - Second Edition [[Packt]](https://www.packtpub.com/product/the-ultimate-kali-linux-book-second-edition/9781801818933) [[Amazon]](https://www.amazon.com/Ultimate-Kali-Linux-Book-penetration/dp/1801818932)

* Mastering Kali Linux for Advanced Penetration Testing - Fourth Edition [[Packt]](https://www.packtpub.com/product/mastering-kali-linux-for-advanced-penetration-testing-fourth-edition/9781801819770) [[Amazon]](https://www.amazon.com/Mastering-Linux-Advanced-Penetration-Testing/dp/1801819777)

## Get to Know the Author
**Shiva V. N. Parasram**
He is the Executive Director and CISO of the Computer Forensics and Security Institute, which specializes in penetration testing, forensics, and advanced cybersecurity training. As the only Certified EC-Council Instructor (CEI) in the Caribbean, he has also trained hundreds in CCNA, CND, CEH, CHFI, ECSA, and CCISO, among other certifications. He has partnered with international companies including Fujitsu (Trinidad) and Take It To The Top LLC as the lead trainer for advanced cybersecurity courses. Shiva is also the author of two other books from Packt Publishing and has delivered workshops, lectures, and keynote speeches regionally for ISACA, universities, law associations, and other institutions.
