# Malware Development for Ethical Hackers

<a href="https://www.packtpub.com/product/malware-development-for-ethical-hackers/9781801810173?utm_source=github&utm_medium=repository&utm_campaign=9781801810173"><img src="https://content.packt.com/B21638/cover_image_small.jpg" alt="Malware Development for Ethical Hackers" height="256px" align="right"></a>

This is the code repository for [Malware Development for Ethical Hackers](https://www.packtpub.com/product/malware-development-for-ethical-hackers/9781801810173?utm_source=github&utm_medium=repository&utm_campaign=9781801810173), published by Packt.

**Learn how to develop various types of malware to strengthen cybersecurity**

## What is this book about?

This book covers the following exciting features:
* Familiarize yourself with the logic of real malware developers for cybersecurity
* Get to grips with the development of malware over the years using examples
* Understand the process of reconstructing APT attacks and their techniques
* Design methods to bypass security mechanisms for your red team scenarios
* Explore over 80 working examples of malware
* Get to grips with the close relationship between mathematics and modern malware

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1801810176) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example,

The code will look like the following:
```
pVirtualAlloc = GetProcAddress(GetModuleHandle("kernel32.dll"), "VirtualAlloc");

payload_mem = pVirtualAlloc(0, payload_len, MEM_COMMIT | MEM_RESERVE, PAGE_READWRITE);
```

**Following is what you need for this book:**
This book is for penetration testers, exploit developers, ethical hackers, red teamers, and offensive security researchers. Anyone interested in cybersecurity and ethical hacking will also find this book helpful. Familiarity with core ethical hacking and cybersecurity concepts will help you understand the topics discussed in this book more easily.

With the following software and hardware list you can run all code files present in the book (Chapter 1-16).
### Software and Hardware List
| Chapter | Software required | OS required |
| -------- | ------------------------------------ | ----------------------------------- |
| 1-16 | Mingw for Linux (GCC) | Kali Linux or Parrot Security OS |
| 1-16 | Oracle VirtualBox 7.0 | Linux or Windows |
| 1-16 | Microsoft Sysinternals Suite | Windows 7, Windows 10 |
| 1-16 | Process Hacker 2 | Windows 7, Windows 10 |
| 1-16 | x64dbg debugger | Windows 10 |
| 1-16 | PE-bear | Windows 7, Windows 10 |

### Related products
* Malware Science [[Packt]](https://www.packtpub.com/product/malware-science/9781804618646?utm_source=github&utm_medium=repository&utm_campaign=9781804618646) [[Amazon]](https://www.amazon.com/dp/1804618640)

* Hands-On Ethical Hacking Tactics [[Packt]](https://www.packtpub.com/product/hands-on-ethical-hacking-tactics/9781801810081?utm_source=github&utm_medium=repository&utm_campaign=9781801810081) [[Amazon]](https://www.amazon.com/dp/1801810087)

## Get to Know the Author
**Zhassulan Zhussupov**
is a professional who wears many hats: software developer, cybersecurity enthusiast, and mathematician. He has been developing products for law enforcement for over ten years. Professionally, Zhasulan shares his experience as a malware analyst and threat hunter at the MSSP Research Lab in Kazakhstan, a cybersecurity researcher at Websec B.V. in the Netherlands, and Cyber5W in the USA. He has also actively contributed to the Malpedia project. Zhassulan's literary achievements include writing the popular ebooks "MD MZ Malware Development" and "Malwild: Malware in the Wild," details of which can be found on his personal Github page. He is the author and co-author of numerous articles on cybersecurity blogs and has also spoken at various international conferences like Black Hat, DEFCON, BSides, Standoff, and many others. His love for his family is reflected in his role as a loving husband and caring father.


### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781801810173">https://packt.link/free-ebook/9781801810173 </a> </p>
