


# Penetration Testing Azure for Ethical Hackers

<a href="https://www.packtpub.com/security/penetration-testing-azure-for-ethical-hackers?utm_source=github&utm_medium=repository&utm_campaign=9781839212932"><img src="https://static.packt-cdn.com/products/9781839212932/cover/smaller" alt="Penetration Testing Azure for Ethical Hackers" height="256px" align="right"></a>

This is the code repository for [Penetration Testing Azure for Ethical Hackers](https://www.packtpub.com/security/penetration-testing-azure-for-ethical-hackers?utm_source=github&utm_medium=repository&utm_campaign=9781839212932), published by Packt.

**Develop practical skills to perform pentesting and risk assessment of Microsoft Azure environments**

## What is this book about?
Security professionals working with Azure will be able to put their knowledge to work with this practical guide to penetration testing. The book provides a hands-on approach to exploring Azure penetration testing methodologies that will help you get up and running in no time with the help of a variety of real-world examples, scripts, and ready-to-use source code. 

This book covers the following exciting features:
* Identify how administrators misconfigure Azure services, leaving them open to exploitation
* Understand how to detect cloud infrastructure, service, and application misconfigurations
* Explore processes and techniques for exploiting common Azure security issues
* Use on-premises networks to pivot and escalate access within Azure
* Diagnose gaps and weaknesses in Azure security implementations
Understand how attackers can escalate privileges in Azure AD

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1839212934) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, Chapter02.

The code will look like the following:
```
{
''assignableScopes'': [
''/''
],
```

**Following is what you need for this book:**
This book is for new and experienced infosec enthusiasts who want to learn how to simulate real-world Azure attacks using tactics, techniques, and procedures (TTPs) that adversaries use in cloud breaches. Any technology professional working with the Azure platform (including Azure administrators, developers, and DevOps engineers) interested in learning how attackers exploit vulnerabilities in Azure hosted infrastructure, applications, and services will find this book useful.

With the following software and hardware list you can run all code files present in the book (Chapter 1-8).
### Software and Hardware List
| Chapter | Software required | OS required |
| -------- | ------------------------------------ | ----------------------------------- |
| 1-8 | Azure Subscription | Windows, Mac OS X, and Linux (Any) |

We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](https://static.packt-cdn.com/downloads/9781839212932_ColorImages.pdf).

### Errata
* Page 94 (Paragraph 3, Point no 2): Change your directory path to the MicroBurst directory and import the PowerShell functions using the fp;;pwomg commands: _should_be_ Change your directory path to the MicroBurst directory and import the PowerShell functions using the following commands:

### Related products
* Learn Azure Sentinel [[Packt]](https://www.packtpub.com/product/learn-azure-sentinel/9781838980924?utm_source=github&utm_medium=repository&utm_campaign=9781838980924) [[Amazon]](https://www.amazon.com/dp/183898092X)

* Microsoft Azure Security Technologies Certification and Beyond [[Packt]](https://www.packtpub.com/product/microsoft-azure-security-technologies-certification-and-beyond/9781800562653?utm_source=github&utm_medium=repository&utm_campaign=9781800562653) [[Amazon]](https://www.amazon.com/dp/1800562659)

## Get to Know the Author
**David Okeyode**
is a cloud security architect at the Prisma cloud speedboat at Palo Alto Networks. Before that, he was an independent consultant helping companies to secure their cloud environments through private expert-level training and assessments. He holds 15 professional certifications across Azure and AWS platforms.

David has over a decade of experience in Cybersecurity (consultancy, design, implementation). He has worked with organizations from startups to major enterprises and he regularly speaks on cloud security at major industry events like Microsoft Future Decoded and the European Information Security Summit.

David is married to a lovely girl who makes the best banana cake in the world and they love traveling the world together!

**Karl Fosaaen**
As a Practice Director at NetSPI, Karl leads the Cloud Penetration Testing service line and oversees NetSPI’s Portland, OR office. Karl holds a BS in Computer Science from the University of Minnesota and has over a decade of consulting experience in the computer security industry. Karl spends most of his research time focusing on Azure security and contributing to the NetSPI blog. As part of this research, Karl created the MicroBurst toolkit on GitHub to house many of the PowerShell tools that he uses for testing Azure.

## Other books by the authors
* [Microsoft Azure Security Technologies Certification and Beyond](https://www.packtpub.com/in/security/microsoft-azure-security-technologies-certification-guide?utm_source=github&utm_medium=repository&utm_campaign=9781800562653)
### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781839212932">https://packt.link/free-ebook/9781839212932 </a> </p>
