package main
import (
    "encoding/json"
    "net/http"
    "strings"
    "github.com/gorilla/mux"
)
type User struct {
    ID    int    `json:"id"`
    Name  string `json:"name"`
    Role  string `json:"role"`
}
var users = []User{
    {ID: 1, Name: "Alice", Role: "admin"},
    {ID: 2, Name: "Bob", Role: "user"},
    {ID: 3, Name: "Charlie", Role: "user"},
}
func getCurrentUser(r *http.Request) *User {
    authHeader := r.Header.Get("Authorization")
    if strings.HasPrefix(authHeader, "Bearer ") {
        token := strings.TrimPrefix(authHeader, "Bearer ")
        if token == "admin-token" {
            return &User{ID: 1, Name: "Alice", Role: "admin"}
        }
    }
    return nil
}
func requireAdminRole(next http.Handler) http.Handler {
    return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request){
        user := getCurrentUser(r)
        if user == nil || user.Role != "admin" {
            http.Error(w, "Forbidden", http.StatusForbidden)
            return
        }
        next.ServeHTTP(w, r)
    })
}
func createUser(w http.ResponseWriter, r *http.Request) {
    var newUser User
    json.NewDecoder(r.Body).Decode(&newUser)
    users = append(users, newUser)
    w.WriteHeader(http.StatusCreated)
    json.NewEncoder(w).Encode(newUser)
}
func main() {
    r := mux.NewRouter()
    r.Handle("/admin/create_user", requireAdminRole(http.HandlerFunc(createUser))).Methods("POST")
    http.ListenAndServe(":8000", r)
}

