package main
import (
    "encoding/json"
    "net/http"
    "strconv"
    "github.com/gorilla/mux"
)
type User struct {
    ID    int    `json:"id"`
    Name  string `json:"name"`
    Role  string `json:"role"`
}
var users = []User{
    {ID: 1, Name: "Alice", Role: "admin"},
    {ID: 2, Name: "Bob", Role: "user"},
    {ID: 3, Name: "Charlie", Role: "user"},
}
func createUser(w http.ResponseWriter, r *http.Request) {
    var newUser User
    json.NewDecoder(r.Body).Decode(&newUser)
    users = append(users, newUser)
    w.WriteHeader(http.StatusCreated)
    json.NewEncoder(w).Encode(newUser)
}
func main() {
    r := mux.NewRouter()
    r.HandleFunc("/admin/create_user", createUser).Methods("POST")
    http.ListenAndServe(":8000", r)
}

