from flask import Flask, jsonify, request
app = Flask(__name__)

# Endpoint 1: Get user details
@app.route('/api/user/<int:user_id>', methods=['GET'])
def get_user(user_id):
    if user_id == 1:
        return jsonify({'id': 1, 'name': 'John Doe',
                'email': 'john.doe@example.com'})
    else:
        return jsonify({'error': {'message': 'User not found',
                'code': 404}}), 404

# Endpoint 2: Create a new user
@app.route('/api/user/create', methods=['POST'])
def create_user():
    # Simulate validation error if required parameters are missing
    data = request.get_json()
    if 'name' not in data or 'email' not in data:
        return jsonify({'error': {
            'message': 'Bad Request: Name and email are required', 
            'code': 400}}), 400
    # Simulate server error if user creation fails
    # For demonstration purposes, this will always raise an exception
    raise Exception("Internal Server Error: Failed to create user")

# Endpoint 3: Update user information
@app.route('/api/user/update/<int:user_id>', methods=['PUT'])
def update_user(user_id):
    # Simulate authentication error if user_id is not 1
    if user_id != 1:
        return jsonify({'error': {
            'message': """Unauthorized: Only admin can update user 
            information""", 'code': 401}}), 401
    # Simulate error if name or email is missing in the request
    data = request.get_json()
    if 'name' not in data or 'email' not in data:
        return jsonify({'error': {
            'message': 'Bad Request: Name and email are required', 
            'code': 400}}), 400
    # Simulate server error if user update fails
    # For demonstration purposes, this will always raise an exception
    raise Exception("Internal Server Error: Failed to update user")

# Endpoint 4: Delete user
@app.route('/api/user/delete/<int:user_id>', methods=['DELETE'])
def delete_user(user_id):
    # Simulate authentication error if user_id is not 1
    if user_id != 1:
        return jsonify({'error': {
            'message': 'Unauthorized: Only admin can delete user', 
            'code': 401}}), 401
    # Simulate server error if user deletion fails
    # For demonstration purposes, this will always raise an exception
    raise Exception("Internal Server Error: Failed to delete user")

# Endpoint 5: General error handling
@app.route('/api/error', methods=['GET'])
def error_handling():
    # Simulate a generic server error
    # For demonstration purposes, this will always raise an exception
    raise Exception("Internal Server Error: Unexpected error")
if __name__ == '__main__':
    app.run(debug=True)
