import time
import requests

url = "http://localhost/users"
requests_per_ip = 10
delay_per_ip = 1
num_users = 5

for user_id in range(num_users):
    simulated_ip = f"10.0.0.{user_id+1}"
    print(f"Simulating user with IP: {simulated_ip}")

    # Loop to send requests for the current simulated user
    for i in range(requests_per_ip):
        response = requests.get(url)
        if response.status_code == 200:
            print(f"\tRequest {i+1} successful for user {user_id+1}.")
        else:
            print(f"\tRequest {i+1} failed for user {user_id+1}!")
            print(f"Status code: {response.status_code}")
            if response.status_code == 429 or response.status_code == 503:
                print(f"\tRate limit reached for user {user_id+1}!")
                print("\tWaiting for delay...")
                time.sleep(60)
        time.sleep(delay_per_ip)

print("All requests completed for simulated users.")
