from flask import Flask, request, jsonify
app = Flask(__name__)
def get_current_user():
    return {"id": 2, "name": "Bob", "role": "user"}  # Mocked current user
def get_user_by_id(user_id):
    users = {
        "1": {"id": 1, "name": "Alice", "role": "admin"},
        "2": {"id": 2, "name": "Bob", "role": "user"},
        "3": {"id": 3, "name": "Charlie", "role": "user"}
    }
    return users.get(user_id, None)
@app.route('/user', methods=['GET'])
def get_user():
    current_user = get_current_user()  # Get the authenticated user
    user_id = request.args.get('id')
    user = get_user_by_id(user_id)
    if not user:
        return jsonify({"error": "User not found"}), 404
    # Check if the current user is trying to access their own data
    if str(current_user['id']) != user_id:
        return jsonify({"error": "Forbidden"}), 403
    return jsonify(user)
if __name__ == '__main__':
    app.run()

