import requests
# providing the scope as part of the HTTP GET request
auth_url = "https://api.example.com/oauth/authorize"
params = {
  "client_id": "your_client_id",
  "redirect_uri": "your_redirect_uri",
  "response_type": "code",
  "scope": "read-write"
}
response = requests.get(auth_url, params=params)
# A JWT carrying the granted scope
token = {
  "access_token": "your_access_token",
  "expires_in": 3600,
  "scope": "read"
}
# How you could check the scopes in a request
headers = {
  "Authorization": f"Bearer {your_access_token}"
}

response = requests.get("https://api.example.com/resource", 
                         headers=headers)
# Check if at least read access was granted
if "read" in response.json().get("scopes", []):
  # Access granted
else:
  # Access denied due to insufficient scope

# Creating scopes with Flask
from flask import Flask
from flask_oauthlib.provider import OAuth1Provider

app = Flask(__name__)

scopes = {
  "read": "Read access to all resources",
  "write": "Write access to all resources",
  "user:read": "Read access to user data",
  "user:write": "Write access to user data"
}

@app.route("/api/protected")
@requires_oauth("read")

def protected_resource():
  # Access granted for users with the "read" 

