from flask import Flask, request, jsonify
app = Flask(__name__)
def get_user_by_id(user_id):
    users = {
        "1": {"id": 1, "name": "Alice", "role": "admin"},
        "2": {"id": 2, "name": "Bob", "role": "user"},
        "3": {"id": 3, "name": "Charlie", "role": "user"}
    }
    return users.get(user_id, None)
@app.route('/user', methods=['GET'])
def get_user():
    user_id = request.args.get('id')
    user = get_user_by_id(user_id)
    if user:
        return jsonify(user)
    else:
        return jsonify({"error": "User not found"}), 404
if __name__ == '__main__':
    app.run()

