from flask import Flask, request, jsonify

app = Flask(__name__)
users = {
    1: {"id": 1, "name": "Alice", "email": "alice@example.com", "role": "user"},
    2: {"id": 2, "name": "Bob", "email": "bob@example.com", "role": "user"},
    3: {"id": 3, "name": "Eve", "email": "eve@example.com", "role": "admin"}
}

transactions = {
    1: {"id": 1, "user_id": 1, "amount": 100, "status": "pending"},
    2: {"id": 2, "user_id": 2, "amount": 200, "status": "pending"},
    3: {"id": 3, "user_id": 3, "amount": 300, "status": "completed"}
}

@app.route('/api/user/<int:user_id>', methods=['GET'])
def get_user(user_id):
    user = users.get(user_id)
    if user:
        return jsonify(user)
    return jsonify({"error": "User not found"}), 404

@app.route('/api/transaction/<int:transaction_id>', methods=['GET'])
def get_transaction(transaction_id):
    transaction = transactions.get(transaction_id)
    if transaction:
        return jsonify(transaction)
    return jsonify({"error": "Transaction not found"}), 404

@app.route('/api/admin/update_status', methods=['POST'])
def update_transaction_status():
    transaction_id = request.form.get('transaction_id')
    new_status = request.form.get('status')
    auth = request.form.get('auth')

    if auth != "admin_secret":
        return jsonify({"error": "Unauthorized"}), 403
    transaction = transactions.get(int(transaction_id))

    if transaction:
        transaction['status'] = new_status
        return jsonify({"message": "Transaction status updated"})
    return jsonify({"error": "Transaction not found"}), 404

@app.route('/api/admin/change_role', methods=['POST'])
def change_user_role():
    user_id = request.form.get('user_id')
    new_role = request.form.get('role')
    auth = request.form.get('auth')

    if auth != "admin_secret":
        return jsonify({"error": "Unauthorized"}), 403
    user = users.get(int(user_id))

    if user:
        user['role'] = new_role
        return jsonify({"message": "User role updated"})
    return jsonify({"error": "User not found"}), 404

if __name__ == '__main__':
    app.run(debug=True)
