# Helpful links used in Chapter 04
- PowerShell Protect-CmsMessage Example Code, Limitations and Errors: https://www.sans.org/blog/powershell-protect-cmsmessage-example-code/
- Protect-CMSMessage: https://learn.microsoft.com/en-us/powershell/module/microsoft.powershell.security/protect-cmsmessage
- Unprotect-CMSMessage: https://learn.microsoft.com/en-us/powershell/module/microsoft.powershell.security/unprotect-cmsmessage
- Protected Event Logging: https://devblogs.microsoft.com/powershell/powershell-theblue-team/#protected-event-logging
- Start-Transcript parameters: https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.host/start-transcript?view=powershell-7#parameters
- wevtutil: https://docs.microsoft.com/de-de/windows-server/administration/windows-commands/wevtutil
- Detecting and Preventing PowerShell Downgrade Attacks: https://www.leeholmes.com/detecting-and-preventing-powershell-downgrade-attacks/ (Original: https://www.leeholmes.com/blog/2017/03/17/detecting-and-preventing-powershelldowngrade-attacks/)
- Microsoft Security and Compliance Toolkit (SCT): https://www.microsoft.com/en-us/download/etails.aspx?id=55319
- Windows 10 and Windows Server 2016 security auditing and monitoring reference: https://www.microsoft.com/en-us/download/details.aspx?id=52630
- EventList: https://github.com/miriamxyra/EventList
- Hack.lu 2019 presentation (EventList version 1.1.0): https://www.youtube.com/watch?v=nkMDsw4MA48
- Black Hat 2020 presentation (EventList version 2.0.0): https://www.youtube.com/watch?v=3x5-nZ2bfbo
- Review event logs and error codes to troubleshoot issues with Microsoft Defender Antivirus: https://learn.microsoft.com/en-us/microsoft-365/security/defender-endpoint/troubleshoot-microsoft-defender-antivirus
- Understanding Application Control events: https://learn.microsoft.com/en-us/windows/security/threat-protection/windows-defender-application-control/event-id-explanations
- Using Event Viewer with AppLocker: https://learn.microsoft.com/en-us/windows/security/application-security/application-control/windows-defender-application-control/applocker/using-event-viewer-with-applocker (Original https://learn.microsoft.com/en-us/windows/security/threatprotection/windows-defender-application-control/applocker/usingevent-viewer-with-applocker)
- Limit-EventLog: https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/limit-eventlog


# Further Reading
## Auditing – further resources:
- Detecting Offensive PowerShell attack tools: https://adsecurity.org/?p=2604
- Lee Holmes on Downgrade attacks: https://www.leeholmes.com/blog/2017/03/17/detecting-and-preventing-powershell-downgrade-attacks/
- Microsoft Security and Compliance toolkit: https://www.microsoft.com/en-us/download/details.aspx?id=55319
- PowerShell ♥ the Blue Team https://devblogs.microsoft.com/powershell/powershell-the-blue-team/
- Windows 10 and Windows Server 2016 security auditing and monitoring reference: https://www.microsoft.com/en-us/download/details.aspx?id=52630
- PowerShell post-exploitation, the Empire has fallen, You CAN detect PowerShell exploitation by Michael Gough: https://de.slideshare.net/Hackerhurricane/you-can-detect-powershell-attacks
## EventList:
- GitHub: https://github.com/miriamxyra/EventList
- Black Hat presentation 2020 (version 2.0.0): https://www.youtube.com/watch?v=3x5-nZ2bfbo
## Helpful cmdlets and commands:
- Limit-EventLog documentation: https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/limit-eventlog
- Start-Transcript documentation: https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.host/start-transcript?view=powershell-7#parameters
- wevtutil documentation: https://docs.microsoft.com/de-de/windows-server/administration/windows-commands/wevtutil
- Unprotect-CmsMessage: https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.security/unprotect-cmsmessage
## PowerShell Logging and Event logs:
- RFC – CMS: https://www.rfc-editor.org/rfc/rfc5652
- PowerShell Core Group Policy settings: https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/about/about_group_policy_settings?view=powershell-7.1
- PowerShell logging on Non-Windows OS: https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/about/about_logging_non-windows?view=powershell-7
- About Logging on Windows OS: https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/about/about_logging_windows?view=powershell-7.1
- About Event Logs (v 5.1): https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/about/about_eventlogs