# Helpful links used in Chapter 05
- User Rights Assignment: https://learn.microsoft.com/en-us/windows/security/threat-protection/security-policy-settings/user-rights-assignment
- Appendix B: Privileged Accounts and Groups in Active Directory: https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-server-2012-r2-and-2012/dn487460(v=ws.11)
- Secedit: https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-xp/bb490997(v=technet.10)
- Windows API index: https://docs.microsoft.com/en-us/windows/win32/apiindex/windows-api-list
- Add-Type: https://learn.microsoft.com/en-us/powershell/module/microsoft.powershell.utility/add-type
- PInvoke.net: https://pinvoke.net/
- Use PowerShell to Interact with the Windows API: Part 1: https://devblogs.microsoft.com/scripting/use-powershell-to-interact-with-the-windows-api-part-1/
- Use PowerShell to Interact with the Windows API: Part 2: https://devblogs.microsoft.com/scripting/use-powershell-to-interact-with-the-windows-api-part-2/
- Use PowerShell to Interact with the Windows API: Part 3: https://devblogs.microsoft.com/scripting/use-powershell-to-interact-with-the-windows-api-part-3/
- Process Monitor: https://learn.microsoft.com/en-us/sysinternals/downloads/procmon
- WMI System Classes: https://docs.microsoft.com/en-us/windows/win32/wmisdk/wmi-system-classes
- Basics of Tracking WMI Activity: https://www.darkoperator.com/blog/2017/10/14/basics-of-tracking-wmi-activity
- WQL (SQL for WMI): https://learn.microsoft.com/en-us/windows/win32/wmisdk/wql-sql-for-wmi
- Querying with WQL: https://learn.microsoft.com/en-us/windows/win32/wmisdk/querying-with-wql
- PowerShdll: https://github.com/p3nt4/PowerShdll
- nps: https://github.com/Ben0xA/nps
- PowerShell Class: https://learn.microsoft.com/en-us/dotnet/api/system.management.automation.powershell


# Further Reading
## API:
  - Low-Level Windows API Access From PowerShell: https://www.fuzzysecurity.com/tutorials/24.html
## CIM/WMI:
  - Use PowerShell to Manipulate Information with CIM: https://devblogs.microsoft.
com/scripting/use-powershell-to-manipulate-information-with-cim/
## COM hijacking:
  - Demystifying Windows Component Object Model (COM): https://www.221bluestreet.com/- fensive-security/windows-components-object-model/- mystifying-windows-component-object-model-com
  - acCOMplice: https://github.com/nccgroup/acCOMplice
  - COM Hijacking Techniques, David Tulis (DerbyCon): https://www.youtube.com/watch?- pH14BvUiTLY
  - OleViewDotNet by James Forshaw: https://github.com/tyranid/oleviewdotnet
  - COM Class Objects and CLSIDs: https://learn.microsoft.com/en-us/windows/win32/com/com-class-objects-and-clsids
  - Hijacking .NET to Defend PowerShell: https://arxiv.org/ftp/arxiv/papers/1709/1709.07508.pdf
  - Playing around COM objects - PART 1: https://mohamed-fakroud.gitbook.io/red-teamings-dojo/windows-internals/playing-around-com-objects-part-1
  - IUnknown::QueryInterface(REFIID,void**) method (unknwn.h): https://learn.microsoft.com/  -n-us/windows/win32/api/unknwn/nf-unknwn-iunknown-queryinterface(refiid_void)
  - IUnknown interface (unknwn.h): https://learn.microsoft.com/en-us/windows/win32/api/unknwn/  -n-unknwn-iunknown
  - IUnknown::QueryInterface(Q**) method (unknwn.h): https://learn.microsoft.com/en-us/windows/win32/api/unknwn/nf-unknwn-iunknown-queryinterface(q)
## .NET Framework:
  - Assemblies in .NET: https://learn.microsoft.com/en-us/dotnet/standard/assembly/
  - Global Assembly Cache: https://learn.microsoft.com/en-us/dotnet/framework/app-domains/gac
  - .NET Framework versions and dependencies: https://docs.microsoft.com/en-us/dotnet/framework/migration-guide/versions-and-dependencies
## Running PowerShell without powershell.exe:
  - NoPowerShell: https://github.com/bitsadmin/nopowershell
  - PowerLessShell: https://github.com/Mr-Un1k0d3r/PowerLessShell
  - p0wnedShell: https://github.com/Cn33liz/p0wnedShell