# Helpful links used in Chapter 10
- Understand Windows Defender Application Control (WDAC) policy rules and file rules: https://docs.microsoft.com/en-us/windows/security/threat-protection/windows-defender-application-control/select-types-of-rules-to-create
- PowerShell Constrained Language Mode: https://devblogs.microsoft.com/powershell/powershell-constrained-language-mode/
- New-PSSessionOption: https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/new-pssessionoption
- about_Types.ps1xml: https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/about/about_types.ps1xml
- about_Format.ps1xml: https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/about/about_format.ps1xml
- JEA Role Capabilities: https://docs.microsoft.com/en-us/powershell/scripting/learn/remoting/jea/role-capabilities
- How role capabilities are merged: https://docs.microsoft.com/en-us/powershell/scripting/learn/remoting/jea/role-capabilities#how-role-capabilities-are-merged
- Group Managed Service Accounts Overview: https://docs.microsoft.com/en-us/windows-server/security/group-managed-service-accounts/group-managed-service-accounts-overview
- JEA Session Configurations: https://docs.microsoft.com/en-us/powershell/scripting/learn/remoting/jea/session-configurations
- Managing Windows PowerShell Drives: https://docs.microsoft.com/en-us/powershell/scripting/samples/managing-windows-powershell-drives
- Security Descriptor Definition Language: https://docs.microsoft.com/en-us/windows/desktop/secauthz/security-descriptor-definition-language
- Multi-machine configuration with DSC: https://docs.microsoft.com/en-us/powershell/scripting/learn/remoting/jea/register-jea?#multi-machine-configuration-with-dsc
- JEAnalyzer: https://github.com/PSSecTools/JEAnalyzer
- Export_AD_Users_to_CSV.v1.0.ps1: https://github.com/sacroucher/ADScripts/blob/master/Export_AD_Users_to_CSV.v1.0.ps1


# Further Reading
- PowerShell Constrained Language Mode: https://devblogs.microsoft.com/powershell/powershell-constrained-language-mode/
- about_Language_Modes: https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/about/about_language_modes
- Just Enough Administration (official Microsoft documentation): https://docs.microsoft.com/en-us/powershell/scripting/learn/remoting/jea/overview
- JEAnalyzer on GitHub: https://github.com/PSSecTools/JEAnalyzer
- PowerShell ♥ the Blue Team: https://devblogs.microsoft.com/powershell/powershell-the-blue-team/
