# PowerShell Automation and Scripting for Cybersecurity

<a href="https://www.packtpub.com/product/powershell-automation-and-scripting-for-cybersecurity/9781800566378?utm_source=github&utm_medium=repository&utm_campaign=9781801076012"><img src="https://static.packt-cdn.com/products/9781800566378/cover/smaller" alt="PowerShell Automation and Scripting for Cybersecurity" height="256px" align="right"></a>

This is the code repository for [PowerShell Automation and Scripting for Cybersecurity](https://www.packtpub.com/product/powershell-automation-and-scripting-for-cybersecurity/9781800566378?utm_source=github&utm_medium=repository&utm_campaign=9781801076012), published by Packt.

**Hacking and defense for red and blue teamers**

## What is this book about?

This book covers the following exciting features:
* Leverage PowerShell, its mitigation techniques, and detect attacks
* Fortify your environment and systems against threats
* Get unique insights into event logs and IDs in relation to PowerShell and detect attacks
* Configure PSRemoting and learn about risks, bypasses, and best practices
* Use PowerShell for system access, exploitation, and hijacking
* Red and blue team introduction to Active Directory and Azure AD security
* Discover PowerShell security measures for attacks that go deeper than simple commands
* Explore JEA to restrict what commands can be executed

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1800566379) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example.

The code will look like the following:
```
if (<condition>)
{
     <action>
}
```

**Following is what you need for this book:**
This book is for security professionals, penetration testers, system administrators, and red and blue teams looking to learn how to leverage PowerShell for security operations. A basic understanding of PowerShell, cybersecurity fundamentals, and scripting is a must. For some parts a basic understanding of active directory, C++/C#, and assembly can be beneficial.

With the following software and hardware list you can run all code files present in the book (Chapter 1-13).
### Software and Hardware List
| Chapter | Software required | OS required |
| -------- | ------------------------------------ | ----------------------------------- |
| 1-13 | PowerShell 7.3 and above | Windows 10 and above |
| 1-13 | Windows PowerShell 5.1 | Windows Server 2019 and above |
| 1-13 | Visual Studio Code |  |


### Related products
* Reconnaissance for Ethical Hackers [[Packt]](https://www.packtpub.com/product/reconnaissance-for-ethical-hackers/9781837630639?utm_source=github&utm_medium=repository&utm_campaign=9781837630639) [[Amazon]](https://www.amazon.com/dp/1837630631)

* Mastering Windows PowerShell Scripting - Third Edition [[Packt]](https://www.packtpub.com/product/mastering-windows-powershell-scripting-third-edition/9781789536669?utm_source=github&utm_medium=repository&utm_campaign=9781789536669) [[Amazon]](https://www.amazon.com/dp/1789536669)


## Get to Know the Author
**Miriam C. Wiesner**
is a Senior Security Researcher at Microsoft and is part of the team that develops the detections behind Microsoft 365 Defender. She gathered more than 15 years of experience in IT and IT Security working in various roles like System Engineer, Developer, Program Manager, Premier Field Engineer and Security Consultant, and Pentester.
Miriam is also the creator of PowerShell-based open-source tools like EventList and JEAnalyzer. She was invited multiple times to present her research behind her tools at many international conferences like Black Hat (USA, Europe, and Asia), PSConf EU, MITRE ATT&CK workshop, and many more. She lives with her husband and their son near Nuremberg, Germany.


### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781800566378">https://packt.link/free-ebook/9781800566378 </a> </p>
