# Helpful links used in Chapter 07
- What is password hash synchronization with Azure AD?: https://docs.microsoft.com/en-us/azure/active-directory/hybrid/whatis-phs
- What is federation with Azure AD?: https://docs.microsoft.com/en-us/azure/active-directory/hybrid/whatis-fed
- The OAuth 2.0 Authorization Framework: https://datatracker.ietf.org/doc/html/rfc6749
- What is a Primary Refresh Token?: https://docs.microsoft.com/en-us/azure/active-directory/devices/concept-primary-refresh-token
- Azure AD built-in roles: https://docs.microsoft.com/en-us/azure/active-directory/roles/permissions-reference
- Best practices for Azure AD roles: https://docs.microsoft.com/en-us/azure/active-directory/roles/best-practices
- Azure for .NET developers: https://docs.microsoft.com/en-us/dotnet/azure/
- Azure .NET API Reference: https://learn.microsoft.com/en-us/dotnet/api/overview/azure/?view=azure-dotnet
- How to install the Azure CLI: https://docs.microsoft.com/en-us/cli/azure/install-azure-cli
- az reference: https://docs.microsoft.com/en-us/cli/azure/reference-index
- az ad overview: https://docs.microsoft.com/en-us/cli/azure/ad
- How to install Azure PowerShell: https://docs.microsoft.com/en-us/powershell/azure/install-az-ps
- Azure PowerShell Documentation: https://learn.microsoft.com/en-us/powershell/azure/ (Original: https://docs.microsoft.com/de-de/powershell/azure/)
- Microsoft Graph PowerShell documentation: https://learn.microsoft.com/en-us/powershell/microsoftgraph/
- o365creeper: https://github.com/LMGsec/o365creeper
- LyncSniper: https://github.com/mdsecresearch/LyncSniper
- MailSniper: https://github.com/dafthack/MailSniper
- Ruler: https://github.com/sensepost/ruler/wiki/Brute-Force
- SprayingToolkit: https://github.com/byt3bl33d3r/SprayingToolkit
- Azure built-in roles: https://docs.microsoft.com/en-us/azure/role-based-access-control/built-in-roles
- AADInternals: https://github.com/Gerenios/AADInternals
- BloodHound/AzureHound: https://github.com/BloodHoundAD/BloodHound / https://github.com/BloodHoundAD/AzureHound
- msmailprobe: https://github.com/busterb/msmailprobe
- o365creeper: https://github.com/LMGsec/o365creeper
- office365userenum: https://bitbucket.org/grimhacker/office365userenum/src
- o365recon: https://github.com/nyxgeek/o365recon/blob/master/o365recon.ps1
- ROADtools: https://github.com/dirkjanm/ROADtools
- Stormspotter: https://github.com/Azure/Stormspotter
- Azure Storage: https://storage.azure.com
- Azure Key Vault: https://vault.azure.net
- Microsoft Graph: https://graph.microsoft.com
- Azure Management API: https://management.azure.com
- Microsoft Login: https://login.microsoftonline.com/
- Azure Portal https://portal.azure.com/
- ROADtools: https://github.com/dirkjanm/ROADtools
- AADInternals documentation: https://aadinternals.com/aadinternals/
- Detect and Remediate Illicit Consent Grants: https://learn.microsoft.com/en-us/microsoft-365/security/office-365-security/detect-and-remediate-illicit-consent-grants
- Azure Active Directory Seamless Single Sign-On: Technical deep dive: https://learn.microsoft.com/en-us/azure/active-directory/hybrid/how-to-connect-sso-how-it-works
- Hooking Azure AD Connect: https://blog.xpnsec.com/azuread-connect-for-redteam/#Hooking-Azure-AD-Connect
- Overview of Azure AD Multi-Factor Authentication for your organization: https://learn.microsoft.com/en-us/azure/active-directory/fundamentals/concept-fundamentals-mfa-get-started
- What is the identity secure score in Azure Active Directory?: https://learn.microsoft.com/en-us/azure/active-directory/fundamentals/identity-secure-score
- Secure your organization's identities with Azure AD: https://learn.microsoft.com/en-us/azure/active-directory/fundamentals/concept-secure-remote-workers
- Five steps to integrate your apps with Azure Active Directory: https://learn.microsoft.com/en-us/azure/active-directory/fundamentals/five-steps-to-full-application-integration-with-azure-ad
- Security defaults in Azure AD: https://learn.microsoft.com/en-us/azure/active-directory/fundamentals/concept-fundamentals-security-defaults
- Block legacy authentication with Azure AD Conditional Access: https://learn.microsoft.com/en-us/azure/active-directory/conditional-access/block-legacy-authentication

# Further Reading
# AAD devices:
- What is a device identity?: https://docs.microsoft.com/en-us/azure/active-directory/devices/overview
- Plan your hybrid Azure Active Directory join implementation: https://docs.microsoft.com/en-us/azure/active-directory/devices/hybrid-azuread-joinplan
# AAD overview:
- What is Azure Active Directory?: https://adsecurity.org/?p=4211
# Azure AD Connect:
- Download Azure AD Connect: https://www.microsoft.com/en-us/download/details.aspx?id=47594
# Entra ID
- Azure AD is Becoming Microsoft Entra ID: https://techcommunity.microsoft.com/t5/microsoft-entra-azure-ad-blog/azure-ad-is-becoming-microsoft-entra-id/ba-p/2520436
# Federation:
- Authenticate users with WS-Federation in ASP.NET Core: https://docs.microsoft.com/en-us/aspnet/core/security/authentication/ws-federation?view=aspnetcore-5.0
# OAuth:
- RFC – The OAuth 2.0 Authorization Framework: https://datatracker.ietf.org/doc/html/rfc6749
- RFC – The OAuth 2.0 Authorization Framework: Bearer Token Usage: https://datatracker.ietf.org/doc/html/rfc6750
# Other helpful resources:
- Azure Active Directory Red Team: https://github.com/rootsecdev/Azure-Red-Team
- Abusing Azure AD SSO with the Primary Refresh Token: https://dirkjanm.io/abusing-azure-ad-sso-with-the-primary-refresh-token/
- What is a Primary Refresh Token?: https://learn.microsoft.com/en-us/azure/active-directory/devices/concept-primary-refresh-token
- AADInternals documentation: https://aadinternals.com/aadinternals/
- AADInternals on GitHub: https://github.com/Gerenios/AADInternals
# Pass-through Authentication:
- Exploiting PTA: https://blog.xpnsec.com/azuread-connect-forredteam/#
# Pass-Through-Authentication
- The LogonUserW function: https://learn.microsoft.com/en-us/windows/win32/api/winbase/nf-winbase-logonuserw
- PTA deep dive: https://learn.microsoft.com/en-us/azure/activedirectory/hybrid/how-to-connect-pta-security-deep-dive
# Privileged accounts & roles:
- Least privileged roles by task in Azure Active Directory: https://docs.microsoft.com/en-us/azure/active-directory/roles/delegate-by-task
# SAML:
- SAML authentication with Azure Active Directory: https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/auth-saml
- SAML: https://developer.okta.com/docs/concepts/saml/
- The Difference Between SAML 2.0 and OAuth 2.0: https://www.ubisecure.com/uncategorized/difference-between-saml-and-oauth/
- Microsoft identity platform token exchange scenarios with SAML and OIDC/OAuth: https://docs.microsoft.com/en-us/azure/active-directory/develop/scenario-token-exchange-saml-oauth
- How the Microsoft identity platform uses the SAML protocol: https://docs.microsoft.com/en-us/azure/active-directory/develop/active-directory-saml-protocol-reference
