# Helpful links used in Chapter 13
- OWASP Secure Coding Practices-Quick Reference Guide: https://owasp.org/www-project-secure-coding-practices-quick-reference-guide/
- InjectionHunter: https://www.powershellgallery.com/packages/InjectionHunter/1.0.0
- PowerShell Injection Hunter: Security Auditing for PowerShell Scripts: https://devblogs.microsoft.com/powershell/powershell-injection-hunter-security-auditing-for-powershell-scripts/
- DSC module and configuration signing validations: https://learn.microsoft.com/en-us/powershell/scripting/windows-powershell/wmf/whats-new/dsc-improvements?#dsc-module-and-configuration-signing-validations
- Desired State Configuration (DSC) 1.1: https://learn.microsoft.com/en-us/powershell/dsc/overview?view=dsc-1.1
- Desired State Configuration (DSC) 2.0: https://learn.microsoft.com/en-us/powershell/dsc/overview?view=dsc-2.0
- Desired State Configuration (DSC) 3.0: https://learn.microsoft.com/en-us/powershell/dsc/overview?view=dsc-3.0
- Write, Compile, and Apply a Configuration (DSC 1.1): https://learn.microsoft.com/en-us/powershell/dsc/configurations/write-compile-apply-configuration?view=dsc-1.1
- Configurations (DSC 2.0): https://learn.microsoft.com/en-us/powershell/dsc/concepts/configurations?view=dsc-2.0
- Configurations (DSC 3.0): https://learn.microsoft.com/en-us/powershell/dsc/concepts/configurations?view=dsc-3.0
- Download Microsoft Security Compliance Toolkit 1.0: https://www.microsoft.com/en-us/download/details.aspx?id=55319
- Quickstart: Convert Group Policy into DSC: https://learn.microsoft.com/en-us/powershell/dsc/quickstarts/gpo-quickstart
- Scan-UpdatesOffline: https://www.powershellgallery.com/packages/Scan-UpdatesOffline/1.0
- Download wsusscn2.cab: http://go.microsoft.com/fwlink/?linkid=74689
- Configure attack surface reduction capabilities for Microsoft Defender for Endpoint: https://learn.microsoft.com/en-us/microsoft-365/security/defender-endpoint/overview-attack-surface-reduction?view=o365-worldwide#configure-attack-surface-reduction-capabilities



# Further Reading
## LAPS
- Local Administrator Password Solution (LAPS): https://www.microsoft.com/en-us/download/details.aspx?id=46899
## PSScriptAnalyzer
- PSScriptAnalyzer on GitHub: https://github.com/PowerShell/PSScriptAnalyzer
- PSScriptAnalyzer reference: https://learn.microsoft.com/en-us/powershell/module/psscriptanalyzer/?view=ps-modules
- PSScriptAnalyzer module overview: https://learn.microsoft.com/en-us/powershell/utility-modules/psscriptanalyzer/overview?view=ps-modules
## Security baselines and SCT
- Microsoft Security Compliance Toolkit 1.0 - How to use: https://learn.microsoft.com/en-us/windows/security/threat-protection/windows-security-configuration-framework/security-compliance-toolkit-10
- LGPO.exe - Local Group Policy Object Utility, v1.0: https://techcommunity.microsoft.com/t5/microsoft-security-baselines/lgpo-exe-local-group-policy-object-utility-v1-0/ba-p/701045
- New & Updated Security Tools: https://techcommunity.microsoft.com/t5/microsoft-security-baselines/new-amp-updated-security-tools/ba-p/1631613
## Security Updates
- A new version of the Windows Update offline scan file, Wsusscn2.cab, is available for advanced users: https://support.microsoft.com/en-us/topic/a-new-version-of-the-windows-update-offline-scan-file-wsusscn2-cab-is-available-for-advanced-users-fe433f4d-44f4-28e3-88c5-5b22329c0a08
- Detailed information for developers who use the Windows Update offline scan file: https://support.microsoft.com/en-us/topic/detailed-information-for-developers-who-use-the-windows-update-offline-scan-file-51db1d9e-038b-0b15-16e7-149aba45f295
- What is Microsoft Baseline Security Analyzer and its uses?: https://learn.microsoft.com/en-us/windows/security/threat-protection/mbsa-removal-and-guidance
## VBS
- Virtualization-based Security (VBS): https://learn.microsoft.com/en-us/windows-hardware/design/device-experiences/oem-vbs