


# Practical Hardware Pentesting

<a href="https://www.packtpub.com/in/security/practical-hardware-pentesting?utm_source=github&utm_medium=repository&utm_campaign=9781789619133"><img src="https://static.packt-cdn.com/products/9781789619133/cover/smaller" alt="Practical Hardware Pentesting" height="256px" align="right"></a>

This is the code repository for [Practical Hardware Pentesting](https://www.packtpub.com/in/security/practical-hardware-pentesting?utm_source=github&utm_medium=repository&utm_campaign=9781789619133), published by Packt.

**Practical Hardware Pentesting, published by Packt**

## What is this book about?
Hardware pentesting involves leveraging hardware interfaces and communication channels to find vulnerabilities in a device. Practical Hardware Pentesting will help you to plan attacks, hack your embedded devices, and secure the hardware infrastructure. 

This book covers the following exciting features:
* Perform an embedded system test and identify security critical functionalities
* Locate critical security components and buses and learn how to attack them Discover how to dump and modify stored information
* Understand and exploit the relationship between the firmware and hardware
* Identify and attack the security functions supported by the functional blocks of the device
* Develop an attack lab to support advanced device analysis and attacks

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1789619130) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, Chapter02.

The code will look like the following:
```
[xxx.xx] usb xxx: New USB device found, idVendor=04d8,
idProduct=fc92, bcdDevice= 1.00
[xxx.xx] usb xxx: New USB device strings: Mfr=1, Product=2,
SerialNumber=0
```

**Following is what you need for this book:**
This book is for security professionals and researchers who want to get started with hardware security assessment but don’t know where to start. Electrical engineers who want to understand how their devices can be attacked and how to protect against these attacks will also find this book useful.

With the following software and hardware list you can run all code files present in the book (Chapter 1-14).
### Software and Hardware List
| Chapter | Software required | OS required |
| -------- | ------------------------------------ | ----------------------------------- |
| 5-12 | Linux | Any *NIX platform |
| 5,6,11,12 | Bluepill board(STM32F103) | Any *NIX platform |
| 11,12 | Ghidra 9.2+ | Any *NIX platform |
| 5 | GCC 9+ | Any *NIX platform |
| 5,10,12 | OpenOCD 9+ | Any *NIX platform |

We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](http://www.packtpub.com/sites/default/files/downloads/9781789619133_ColorImages.pdf).

## Code in Action

Click on the following link to see the Code in Action:

[Youtube link](https://www.youtube.com/playlist?list=PLeLcvrwLe187LgWy8NTB8q-nbJh5omFjB)

### Related products
* AWS Penetration Testing [[Packt]](https://www.packtpub.com/product/aws-penetration-testing/9781839216923?utm_source=github&utm_medium=repository&utm_campaign=9781839216923) [[Amazon]](https://www.amazon.com/dp/1839216921)

* Free eBook - Learn Kali Linux 2019 [[Packt]](https://www.packtpub.com/free-ebook/learn-kali-linux-2019/9781789611809?utm_source=github&utm_medium=repository&utm_campaign=9781789611809) [[Amazon]](https://www.amazon.com/dp/1789611806)

## Get to Know the Author
**Jean-Georges Valle**
is a hardware penetration tester based in Belgium. His background was in software security, with hardware being a hobby, and he then started to look into the security aspects of hardware. He has spent the last decade testing various systems, from industrial logic controllers to city-scale IoT, and from media distribution to power metering. He has learned to attack embedded systems and to leverage them against cloudscale infrastructure. He is the lead hardware technical expert in an offensive security team of a big four company.

Jean-Georges holds a master's degree in information security and focuses on security at the point of intersection with hardware and software, hardware and software interaction, exploit development in embedded systems, and open source hardware.


### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781789619133">https://packt.link/free-ebook/9781789619133 </a> </p>