//Global variables
let prevCalc = 0;
let calc = "";
let newNumber = true;


//The following function displays a number in the textfield when a number is clicked.
//Note that it keeps concatenating numbers which are clicked. 
function showNum(value) {
    if (newNumber) {
        document.frmCalc.txtNumber.value = value;
        newNumber = false;
    }
    else {
        let cv = document.frmCalc.txtNumber.value;
        if (value == '.') {
            if (cv.length > 0 && cv.indexOf('.') != -1) return; // skip if there is already a '.' in the display
        }
        else if (value == '0') {
            if (cv.length == 1 && cv[0] == '0') return; // skip if there is only a '0' in the display
        }
        else { // assume the function is always called properly with number and . keys, at this point only 1-9 is possible 
            if (cv.length == 1 && cv[0] == '0') {
                cv = ""; // remove this '0' so we don't have something like '034' even though it is theoratically okay
            }
        }
        document.frmCalc.txtNumber.value = cv + value;
    }
}

//The following function decreases the value of displayed number by 1.
//isNaN method checks whether the value passed to the method is a number or not.     
function decrement() {
    var num = parseFloat(document.frmCalc.txtNumber.value);
        if (!(isNaN(num))) {
            num--;
            document.frmCalc.txtNumber.value = num;
            newNumber = true;
        }
}

//The following function is called when "Add" button is clicked. 
//Note that it also changes the values of the global variables.       
function add() {
    var num = parseFloat(document.frmCalc.txtNumber.value);
        if (!(isNaN(num))) {
            prevCalc = num;
            newNumber = true;
            calc = "Add";
        }
}

//The following function is called when "Subtract" ("-") button is clicked. 
//Note that it also changes the values of the global variables.       
function subtract() {
    var num = parseFloat(document.frmCalc.txtNumber.value);
        if (!(isNaN(num))) {
            prevCalc = num;
            newNumber = true;
            calc = "Sub";
        }
}

//The following function is called when "Calculate" button is clicked.
//Note that this function is dependent on the value of global variable.        
function calculate() {
    var num = parseFloat(document.frmCalc.txtNumber.value);
        if (!(isNaN(num))) {
            if (calc == "Add"){
                let total = prevCalc + num;
                document.frmCalc.txtNumber.value = total;
                newNumber = true;
            }
            else if (calc == "Sub") {
                let total = prevCalc - num;
                document.frmCalc.txtNumber.value = total;
                newNumber = true;
            }
        }
}

function clear() {
	document.frmCalc.txtNumber.value = "";
	prevCalc = 0;
	calc = "";
    newNumber = true;
}