"use strict";

/* 
 * In this implementation, all the logic of the calculator is encapsulated in
 * a class called Calculator. The only connection between the Calculator (model) 
 * and the HTML (view) is the disptach method that takes the event name and the 
 * current display value as the input and returns the new display value.
 * The event handling mechanism (control) connects the model and view together.
 * This is an example of a Model-View-Control (MVC) design.
*/
document.addEventListener("DOMContentLoaded", () => {
    // create the calc object
    let calc = new Calculator();

    // hook up click events for all buttons at the form level
    let formobj = document.querySelector("form[name='frmCalc']");
    formobj.addEventListener("click", formHandler);
});

