"use strict";

class Calculator {

    constructor() {
        this.prevCalc = 0;
        this.calc = "";
        this.newNumber = true;
    }

//The following function displays a number in the textfield when a number is clicked.
//Note that it keeps concatenating numbers which are clicked. 
    showNum(cv, value) {
        let newv = "";
        if (this.newNumber) {
            newv = value;
            this.newNumber = false;
        }
        else {
            if (value == '.') {
                if (cv.length > 0 && cv.indexOf('.') != -1) {
                    return cv;
                }  // skip if there is already a '.' in the display
            }
            else if (value == '0') {
                if (cv.length == 1 && cv[0] == '0') {
                    return cv;
                } // skip if there is only a '0' in the display
            }
            else { // assume the function is always called properly with number and . keys, at this point only 1-9 is possible 
                if (cv.length == 1 && cv[0] == '0') {
                    cv = ""; // remove this '0' so we don't have something like '034' even though it is theoratically okay
                }
            }
            newv = cv + value;
        }
        return newv;
    }

//The following function decreases the value of displayed number by 1.
//isNaN method checks whether the value passed to the method is a number or not.     
    decrement(cv) {

    }

//The following function is called when "Add" button is clicked. 
//Note that it also changes the values of the global variables.       
    add(cv) {
        let num = parseFloat(cv);
        if (!(isNaN(num))) {
            this.prevCalc = num;
            this.newNumber = true;
            this.calc = "Add";
        }
        return cv;
    }

//The following function is called when "Subtract" ("-") button is clicked. 
//Note that it also changes the values of the global variables.       
    subtract(cv) {
        let num = parseFloat(cv);
        if (!(isNaN(num))) {
            this.prevCalc = num;
            this.newNumber = true;
            this.calc = "Sub";
        }
        return cv;
    }

//The following function is called when "Calculate" button is clicked.
//Note that this function is dependent on the value of global variable.        
    calculate(cv) {
        let newv = "";
        let num = parseFloat(cv);
        if (!(isNaN(num))) {
            if (this.calc == "Add"){
                let total = this.prevCalc + num;
                newv = total;
                this.newNumber = true;
            }
            else if (this.calc == "Sub") {
                let total = this.prevCalc - num;
                newv = total;
                this.newNumber = true;
            }
        }
        return newv;
    }

    clear() {
    	this.prevCalc = 0;
    	this.calc = "";
        this.newNumber = true;
        return "";
    }

    dispatch(evtname, currDisp) {
        let newDisp = "";
        let btnx = parseInt(evtname[3]);
        if (!isNaN(btnx)) {
            newDisp = this.showNum(currDisp, btnx);
        }
        else {
            switch (evtname) {
                case "btnDecimal":
                    newDisp = this.showNum(currDisp, "."); 
                    break;
                case "btnCalc":
                    newDisp = this.calculate(currDisp); 
                    break;
                case "btnPlus":
                    newDisp = this.add(currDisp);                
                    break;
                case "btnMinus":
                    newDisp = this.subtract(currDisp);                
                    break;
                case "btnReset":
                    newDisp = this.clear();
                    break;
            }
        }
        return newDisp;
    }
}
