"use strict";

/*
If you run this code from the file system, it doesn't work correctly with Chrome
or Firefox and may not work correctly with other browsers. To get this code to work 
correctly, you can deploy the app to a web server and run it from that web server.
*/

const setCookie = (name, value, days) => {
    // concatenate cookie name and encoded value
    let cookie = name + "=" + encodeURIComponent(value);

    // if there's a value for days, add max-age to cookie
    if (days !== undefined) {
        cookie += "; max-age=" + days * 24 * 60 * 60;
    }
    // add path to cookie and then set
    cookie += "; path=/";
    document.cookie = cookie;
};

const getCookieByName = name => {
    const cookies = document.cookie;

/* Using regular expression */
    const cpat = RegExp(`${name}=([^;]+);`); //the matched group allows anything except ;
    const matches = cpat.exec(cookies+";"); // the last cookie doesn't have ;, so add it before testing
    if (matches) {
        return decodeURIComponent(matches[1]);
    }
    return "";

/* Using the split method
    const cookie_list = cookies.split(";");

    for (let c of cookie_list) {
        if (c.trim().startsWith(name+"=")) {
            const b = c.indexOf("=")+1;
            return decodeURIComponent(c.substring(b,c.length));
        }
    }
    return "";
*/
};

const deleteCookie = name => 
    document.cookie = name + "=''; max-age=0; path=/";

$(() => {

    if (!location.protocol.startsWith("http")) {
        alert(`Since this application relies on HTTP, it only works correctly when run on a web server.`);
    }
    
    $("#add_task").on("click", () => {  
        const textbox = $("#task");
        const task = textbox.val();
        if (task === "") {
            alert("Please enter a task.");
            textbox.trigger("focus");
        } else {  
            // retrieve tasks cookie value and add new task to it
            let tasks = getCookieByName("tasks");
            tasks = tasks.concat(task, "\n");

            // reset a 21 day persistent cookie for tasks
            setCookie("tasks", tasks, 21); // 21 day persistent cookie

            // clear task text box and re-display tasks
            textbox.val("");
            console.log("tasks: " + getCookieByName("tasks"));
            $("#task_list").val(getCookieByName("tasks"));
            textbox.trigger("focus");
        }
    });
    
    $("#clear_tasks").on("click", () => {
        deleteCookie("tasks");
        $("#task_list").val("");
        $("#task").trigger("focus");
    }); 
    
    $("#task_list").val(getCookieByName("tasks"));  // initial load
    $("#task").trigger("focus");
});